import { View, Text, TouchableOpacity, Pressable } from "react-native";
import React from "react";
import { cartStyle } from "./shoppingCartStyle";
import dpr from "../Utilities/CustomStyleAttribute/dpr";
import DeleteIcon from "../../assets/svgs/my wishlist/delete icon.svg";
import MinusIcon from "../../assets/svgs/cart/minus.svg";
import PlusIcon from "../../assets/svgs/cart/plus.svg";
import Checkbox from "expo-checkbox";
import { useDispatch } from "react-redux";
import { deleteItemFromCart } from "../../redux/slices/cart/getCartProducts";
import { deleteSingleItem } from "../../redux/slices/cart/deleteCartItem/deleteSingleItem";
import useAuth from "../../hooks/useAuth";
import ProgressiveImage from "../../src/components/ProgressiveImage";
import { useNavigation } from "@react-navigation/native";
import useProcessPrice from "../../hooks/useProcessPrice";
import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../hooks/useLangTranslation";
import { PRODUCT_DETAILS } from "../../components/Navigation/RouteNames";
import CustomSVG from "../../src/components/CustomSVG/CustomSVG";

const SingleProduct = ({
    item,
    isCheck,
    handleCheck,
    handleIncrement,
    handleDecrement,
}) => {
    const { trans } = useLangTranslation();
    const navigation = useNavigation();
    const { access_token } = useAuth();
    const processPrice = useProcessPrice();
    const deleteURL = `${BASE_API_URL_STG}/user/cart/delete`;
    let newIsCheck = isCheck.map((str) => Number(str));
    const {
        variation_meta,
        id,
        vendor_id,
        index,
        quantity,
        price,
        slug,
        inventoryEnable,
        availability,
    } = item || {};
    let variationMeta;
    if (variation_meta?.length > 0) {
        variationMeta = JSON.parse(variation_meta.replace(/\\/g, ""));
    }
    const dispatch = useDispatch();
    const handleDelete = () => {
        const data = {
            cartIndex: index,
        };
        handleCheck(false, Number(id), Number(vendor_id));
        dispatch(deleteItemFromCart(index));
        dispatch(
            deleteSingleItem({ access_token, deleteURL, method: "POST", data })
        );
    };
    let disableCheckbox = (!inventoryEnable || availability == 0) ? true : false
    return (
        <View style={cartStyle.singleItemCont}>
            <View style={cartStyle.singleItem}>
                <View style={cartStyle.itemLeftCont}>
                    <TouchableOpacity onPress={() => handleCheck(!newIsCheck.includes(item.id), Number(id), Number(vendor_id))} hitSlop={6}>
                        <Checkbox
                            disabled={disableCheckbox}
                            value={newIsCheck.includes(item.id)}
                            onValueChange={(e) =>
                                handleCheck(e, Number(id), Number(vendor_id))
                            }
                            color={
                                newIsCheck.includes(item.id) ? "#2C2C2C" : "#DFDFDF"
                            }
                            style={cartStyle.checkBoxSize}
                        />
                    </TouchableOpacity>
                    <View style={cartStyle.imgCont}>
                        <ProgressiveImage
                            source={{ uri: item.photo }}
                            style={cartStyle.img}
                        />
                    </View>
                </View>
                <Pressable
                    onPress={() => {
                        navigation.navigate(PRODUCT_DETAILS, {
                            slug: slug,
                            item
                        });
                    }}
                    style={cartStyle.itemRightCont}
                >
                    <View style={cartStyle.itemInfo}>
                        <Text
                            style={cartStyle.itemName}
                            numberOfLines={
                                item.type === "Variable Product" ? 1 : 2
                            }
                        >
                            {item.name}
                        </Text>
                        {item.type === "Variable Product" && (
                            <Text style={cartStyle.itemSize}>
                                {Object.keys(variationMeta)?.map(
                                    (meta, i) =>
                                        `${meta}: ${variationMeta[meta]} ${
                                            i ===
                                            Object.keys(variationMeta)?.length -
                                                1
                                                ? ""
                                                : "|"
                                        } `
                                )}
                            </Text>
                        )}
                        <Text
                            style={[
                                cartStyle.itemName,
                                cartStyle.itemNameSize
                            ]}
                        >
                            {processPrice(item?.price)}
                        </Text>
                        {(!inventoryEnable || availability == 0) && (
                            <Text style={cartStyle.notAvailable}>
                                {trans("Not Available")}
                            </Text>
                        )}
                    </View>
                </Pressable>
                <TouchableOpacity
                    onPress={handleDelete}
                    style={cartStyle.deleteButton}
                >
                    <CustomSVG svgIcon={DeleteIcon}
                        height={dpr(14)}
                        width={dpr(14)}
                        fill={"#898989"}
                    />
                </TouchableOpacity>
            </View>
            <View style={cartStyle.qtyCont}>
                <View style={cartStyle.incDecCont}>
                    <View style={cartStyle.chechBox} />
                    {item?.is_individual_sale != "1" && (
                        <View style={cartStyle.incDec}>
                            <TouchableOpacity
                                disabled={quantity > 1 ? false : true}
                                style={cartStyle.inc}
                                onPress={() => handleDecrement(id)}
                            >
                                <CustomSVG svgIcon={MinusIcon} fill={"#2C2C2C"} />
                            </TouchableOpacity>
                            <View style={[cartStyle.inc, cartStyle.width]}>
                                <Text style={cartStyle.hr} />
                            </View>
                            <TouchableOpacity
                                style={cartStyle.inc}
                                onPress={() => handleIncrement(id)}
                            >
                                <CustomSVG svgIcon={PlusIcon} fill={"#2C2C2C"} />
                            </TouchableOpacity>
                        </View>
                    )}
                    <Text style={cartStyle.qty}>{trans("Qty")}: {quantity}</Text>
                </View>
                <View
                    style={[cartStyle.itemRightCont, cartStyle.itemRightContAlign]}
                >
                    <Text style={[cartStyle.qty, cartStyle.qtySize]}>
                        {processPrice(Number(price) * Number(quantity))}
                    </Text>
                </View>
            </View>
        </View>
    );
};

export default SingleProduct;
